;/* $Header: /lsid/semaphore/clarinet/custom/hwaddr_.h 1.6 1997/03/21 00:55:16 donm Exp $ */
;/* (C) Copyright 1996, Hewlett-Packard Company, all rights reserved. */
;/* */
;/* This is the unix version of the dos file. */
;/* Use "ux2dos' and "dos2ux" to convert. */

;/*######################################################################### */
;/*#### WARNING: THIS FILE IS USED BY CUSTOM SIGNAL MODES (srcusr.asm) ##### */
;/*######################################################################### */

; !2 indicates change in the second turn of the board.


  ; The following is the on chip dsp x peripheral memory space
  ; Refer to DSP56KCC Users Manual sect 4.7, pg 4-12

Fdsp_ipr	equ	x:$ffff	; interrupt priority register
Fdsp_bcr	equ	x:$fffe	; port A bus control register
Fdsp_pctl	equ	x:$fffd	; PLL control register
Fdsp_oncer	equ	x:$fffc ; OnCE GDB register

Fdsp_stx_hi	equ	x:$fff6	; SCI high transmit data register
Fdsp_srx_hi	equ	x:$fff6	; SCI high receive data register
Fdsp_stx_mid	equ	x:$fff5	; SCI mid transmit data register
Fdsp_srx_mid	equ	x:$fff5	; SCI mid receive data register
Fdsp_stx_lo	equ	x:$fff4	; SCI low transmit data register
Fdsp_srx_lo	equ	x:$fff4	; SCI low receive data register
Fdsp_stxa	equ	x:$fff3	; SCI transmit data address register
Fdsp_sccr	equ	x:$fff2	; SCI control register
Fdsp_ssr	equ	x:$fff1	; SCI interface status register
Fdsp_scr	equ	x:$fff0 ; SCI interface control register
Fdsp_tx 	equ	x:$ffef	; SSI transmit data register
Fdsp_rx 	equ	x:$ffef	; SSI receive data register
Fdsp_tsr	equ	x:$ffee	; SSI time slot register
Fdsp_ssisr	equ	x:$ffee	; SSI status register
Fdsp_crb	equ	x:$ffed	; SSI control register B
Fdsp_cra	equ	x:$ffec	; SSI control register A
Fdsp_htx	equ	x:$ffeb	; Host port receive transmit
Fdsp_hrx	equ	x:$ffeb	; Host port receive register

Fdsp_hsr	equ	x:$ffe9	; Host port status register
Fdsp_hcr	equ	x:$ffe8	; Host port control register

Fdsp_pcd	equ	x:$ffe5	; Port C data register
Fdsp_pbd	equ	x:$ffe4	; Port B data register
Fdsp_pcddr	equ	x:$ffe3	; Port C data direction register
Fdsp_pbddr	equ	x:$ffe2	; Port B data direction register
Fdsp_pcc	equ	x:$ffe1	; Port C control register
Fdsp_pbc	equ	x:$ffe0	; Port B control register
Fdsp_tcr	equ	x:$ffdf	; Timer count register
Fdsp_tcsr	equ	x:$ffde	; Timer status register
Fdsp_tccr	equ	x:$ffde	; Timer control register

  ; x:$ffdd thru $ffc0 are not valid


  ; The following is the external y peripheral memory space

Fsrc_adc	equ	y:$ffff	; write/read register, ADC
Fsrc_asr	equ	y:$fffe	; read register, msb aligned see srcset_.h
Fsrc_id		equ	y:$fffd	; read Source HW ID reg
Fsrc_page	equ	y:$fffd	; write Flash Rom Page register (bits 17,16) !2
Fsrc_resetcr	equ	y:$fffc	; read, Reset control register set by 96k
				;         cleared on read by 56k
Fsrc_1zd1wr	equ	y:$fffc	; write, DC zero DAC, post-range DAC !2
Fsrc_prn	equ	y:$fffb	; read prn value (24-bits) !2
				; reading clocks PRN !2
Fsrc_acr	equ	y:$fffb	; write src analog control see srcset_.h
Fsrc_rngwr	equ	y:$fffa	; write reg, range DAC, LSB (0:7) aligned
Fsrc_1zd0wr	equ	y:$fff9	; write reg, DC zero DAC, LSB (0:11) aligned
Fsrc_sisr	equ	y:$fff8	; write reg,24 bit IRQ status read by 96002
Fsrc_outclose	equ	y:$fff7	; write strobe, closes the relay connecting
				; the source to the output if no overload
Fsrc_outopen	equ	y:$fff6	; write strobe, opens source from output
				; setting overload bit
Fsrc_clrshut	equ	y:$fff5	; write strobe, clr shutdown
Fsrc_fshut	equ	y:$fff4	; write strobe, fast (4ms) shutdown
Fsrc_sshut	equ	y:$fff3	; write strobe, slow (5sec) shutdown
Fsrc_dfsync	equ	y:$fff2	; write strobe, reset DF1700 and sync LRCI
Fsrc_prnrst	equ	y:$fff1	; write strobe, reset PRN to zero state. !2
			; do multiple reads to initialize to another value !2
  ; y:$fff0 thru y:$ffee not used
Fsrc_outclose_2	equ	y:$ffed	; write strobe, closes CH2 output relay
Fsrc_2zd1wr	equ	y:$ffec	; write, CH2 DC zero DAC, post-range DAC !2
Fsrc_outopen_2	equ	y:$ffeb	; write strobe, CH2 opens source from output
				; setting overload bit
Fsrc_rng2wr	equ 	y:$ffea ; write reg, CH2 range DAC
Fsrc_2zd0wr	equ	y:$ffe9	; write reg, CH2 DC zero DAC, LSB(0:11) aligned

  ; ffe0 thru ffe8, not used but avalable for future io registers

  ; y:$ffc0 thru y:$ffdf (32 bytes words) available as short io addressable ram

